<?php
/* Getmail Roundcube Plugin (RC0.4 and above)
 * Version 1.0, March 17, 2013
 * Copyright (c) 2013, Ron Guerin <ron@vnetworx.net>
 * Fork of ispcp_fetchmail developed by Arthur Mayer, a.mayer@citex.net
 * Released under GPL license (http://www.gnu.org/licenses/gpl.txt)*
 */

class getmail_retriever extends rcube_plugin {
	public $task = 'settings';
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function init() {
		$this->load_config();
		$this->add_texts('localization/', true);
		$rcmail = rcmail::get_instance();
		$this->register_action('plugin.getmail_retriever', array($this, 'init_html'));
		$this->register_action('plugin.getmail_retriever.save', array($this, 'save'));
		$this->register_action('plugin.getmail_retriever.del', array($this, 'del'));
		$this->register_action('plugin.getmail_retriever.enable', array($this, 'enable'));
		$this->register_action('plugin.getmail_retriever.disable', array($this, 'disable'));
		$this->api->output->add_handler('getmail_form', array($this, 'gen_form'));
		$this->api->output->add_handler('getmail_table', array($this, 'gen_table'));
		$this->include_script('getmail.js');
	}
	function load_config() {
		$rcmail = rcmail::get_instance();
		$config = "plugins/getmail_retriever/config/config.inc.php";
		if (file_exists($config))
			include $config;
		else if (file_exists($config . ".dist"))
			include $config . ".dist";
		if (is_array($rcmail_config)) {
			$arr = array_merge($rcmail->config->all(), $rcmail_config);
			$rcmail->config->merge($arr);
		}
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function init_html() {
		$rcmail = rcmail::get_instance();
		$rcmail->output->set_pagetitle($this->gettext('getmail'));
		$rcmail->output->send('getmail_retriever.getmail');
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function disable() {
		$rcmail = rcmail::get_instance();
		$id = get_input_value('_id', RCUBE_INPUT_GET);
		if ($id != 0 || $id != '') {
			$sql = "UPDATE getmail SET active = '0' WHERE mailget_id = '$id' LIMIT 1";
			$update = $rcmail->db->query($sql);
		}
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function enable() {
		$rcmail = rcmail::get_instance();
		$id     = get_input_value('_id', RCUBE_INPUT_GET);
		if ($id != 0 || $id != '') {
			$sql = "UPDATE getmail SET active = '1' WHERE mailget_id = '$id' LIMIT 1";
			$update = $rcmail->db->query($sql);
		}
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function del() {
		$rcmail = rcmail::get_instance();
		$id = get_input_value('_id', RCUBE_INPUT_GET);
		if ($id != 0 || $id != '') {
			$sql = "DELETE FROM getmail WHERE mailget_id = '$id' LIMIT 1";
			$delete = $rcmail->db->query($sql);
		}
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function save() {
		$rcmail     = rcmail::get_instance();
		$id         = get_input_value('_id', RCUBE_INPUT_POST);
		$userhere   = $rcmail->user->data['username'];
		$type       = get_input_value('_getmailtype', RCUBE_INPUT_POST);
		$server     = get_input_value('_getmailserver', RCUBE_INPUT_POST);
		$user       = get_input_value('_getmailuser', RCUBE_INPUT_POST);
		$pass       = get_input_value('_getmailpass', RCUBE_INPUT_POST);
		$delete     = get_input_value('_getmaildelete', RCUBE_INPUT_POST);
		$getallnext = get_input_value('_getmailgetallnext', RCUBE_INPUT_POST);
		$getonlynew = get_input_value('_getmailgetonlynew', RCUBE_INPUT_POST);
		$enabled    = get_input_value('_getmailenabled', RCUBE_INPUT_POST);
		$ssl        = get_input_value('_getmailssl', RCUBE_INPUT_POST);
		$folder	    = get_input_value('_getmailfolder', RCUBE_INPUT_POST);
		$poll	    = get_input_value('_getmailpoll', RCUBE_INPUT_POST);
		$newentry   = get_input_value('_getmailnewentry', RCUBE_INPUT_POST);
		if (!$delete) { $delete = 0; } else { $delete = 1; }
		if (!$enabled) { $enabled = 0; } else { $enabled = 1; }
		if ($newentry OR $id == '') {
			$sql = "SELECT * FROM getmail WHERE userhere='".$userhere."'";
			$result = $rcmail->db->query($sql);
			$limit = $rcmail->config->get('getmail_limit');
			$num_rows = $rcmail->db->num_rows($result);
			if (($num_rows < $limit) || ((int)$limit == 0)) {
				$sql = "INSERT INTO getmail (`userhere`, `active`, `ssl`, `delete`, `getallnext`, `getonlynew`, `type`, `server`, `user`, `pass`, `folder`, `poll`) VALUES ('$userhere', '$enabled', '$ssl', '$delete', '$getallnext', '$getonlynew', '$type', '$server', '$user', '$pass', '$folder', '$poll')";
				$insert = $rcmail->db->query($sql);
				$rcmail->output->command('display_message', $this->gettext('successfullysaved'), 'confirmation');
			} else {
				$rcmail->output->command('display_message', 'Error: '.$this->gettext('getmaillimitreached'), 'error');
			}
		}
		else {
			$sql = "UPDATE getmail SET `userhere`='$userhere', `active`='$enabled', `ssl`='$ssl', `delete`='$delete', `getallnext`='$getallnext', `getonlynew`='$getonlynew', `type`='$type', `server`='$server', `user`='$user', `pass`='$pass', `folder`='$folder', `poll`='$poll' WHERE `mailget_id`='$id' LIMIT 1";
			$update = $rcmail->db->query($sql);
			$rcmail->output->command('display_message', $this->gettext('successfullysaved'), 'confirmation');
		}
		$this->init_html();
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function gen_form() {
		$rcmail = rcmail::get_instance();
		$id = get_input_value('_id', RCUBE_INPUT_GET);
		$userhere = $rcmail->user->data['username'];
		if ($id != '' || $id != 0) {
			$sql = "SELECT * FROM getmail WHERE userhere='".$userhere."' AND mailget_id='".$id."'";
			$result = $rcmail->db->query($sql);
			while ($row = $rcmail->db->fetch_assoc($result)) {
				$mailget_id    = $row['mailget_id'];
				$enabled       = $row['active'];
				$type          = $row['type'];
				$server        = $row['server'];
				$user          = $row['user'];
				$pass          = $row['pass'];
				$ssl		   = $row['ssl'];
				$folder        = $row['folder'];
				$delete        = $row['delete'];
				$getonlynew    = $row['getonlynew'];
				$getallnext    = $row['getallnext'];
				$poll          = $row['poll'];
				$lastpoll      = $row['lastpoll'];
			}
		}
		else {
			// New entry
			$ssl = TRUE;
			$getonlynew = TRUE;
		}
		$newentry = 0;
		$out .= '<fieldset><legend>'.$this->gettext('getmail').' - '.$userhere.'</legend>'."\n";
		$out .= '<br />' . "\n";
		$out .= '<table' . $attrib_str . ">\n\n";
		$hidden_id = new html_hiddenfield(array(
			'name' => '_id',
			'value' => $mailget_id
		));
		$out .= $hidden_id->show();
		$field_id               = 'getmailenabled';
		$input_getmailenabled = new html_checkbox(array(
			'name' => '_getmailenabled',
			'id' => $field_id,
			'value' => '1'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailenabled')), $input_getmailenabled->show($enabled));
		$field_id           = 'getmailtype';
		$input_getmailtype = new html_select(array(
			'name' => '_getmailtype',
			'id' => $field_id
		));
		$input_getmailtype->add(array(
			'POP3',
			'IMAP'
		), array(
			'pop3',
			'imap'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailtype')), $input_getmailtype->show($type));
		$field_id               = 'getmailssl';
		$input_getmailssl = new html_checkbox(array(
			'name' => '_getmailssl',
			'id' => $field_id,
			'value' => '1'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailssl')), $input_getmailssl->show($ssl));
		$field_id              = 'getmailserver';
		$input_getmailserver = new html_inputfield(array(
			'name' => '_getmailserver',
			'id' => $field_id,
			'maxlength' => 320,
			'size' => 40
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailserver')), $input_getmailserver->show($server));
		$field_id            = 'getmailuser';
		$input_getmailuser = new html_inputfield(array(
			'name' => '_getmailuser',
			'id' => $field_id,
			'maxlength' => 320,
			'size' => 40
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('username')), $input_getmailuser->show($user));
		$field_id            = 'getmailpass';
		$input_getmailpass = new html_passwordfield(array(
			'name' => '_getmailpass',
			'id' => $field_id,
			'maxlength' => 320,
			'size' => 40,
			'autocomplete' => 'off'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailpass')), $input_getmailpass->show($pass));
		$field_id            = 'getmailfolder';
		$input_getmailfolder = new html_inputfield(array(
			'name' => '_getmailfolder',
			'id' => $field_id,
			'maxlength' => 320,
			'size' => 40,
			'autocomplete' => 'off'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailfolder')), $input_getmailfolder->show($folder));
		$field_id            = 'getmailpoll';
		$input_getmailpoll = new html_inputfield(array(
			'name' => '_getmailpoll',
			'id' => $field_id,
			'maxlength' => 320,
			'size' => 40,
			'autocomplete' => 'off'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailpoll')), $input_getmailpoll->show($poll));
		$field_id              = 'getmailgetonlynew';
		$input_getmailgetonlynew = new html_checkbox(array(
			'name' => '_getmailgetonlynew',
			'id' => $field_id,
			'value' => '1'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailgetonlynew')), $input_getmailgetonlynew->show($getonlynew));
		$field_id              = 'getmaildelete';
		$input_getmaildelete = new html_checkbox(array(
			'name' => '_getmaildelete',
			'id' => $field_id,
			'value' => '1'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmaildelete')), $input_getmaildelete->show($delete));
		$field_id              = 'getmailgetallnext';
		$input_getmailgetallnext = new html_checkbox(array(
			'name' => '_getmailgetallnext',
			'id' => $field_id,
			'value' => '1'
		));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailgetallnext')), $input_getmailgetallnext->show($getallnext));
		$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", 'getmaillastpoll', rep_specialchars_output($this->gettext('getmaillastpoll')), (($lastpoll == 0) ? rep_specialchars_output($this->gettext('getmailnotpolled')) : date('r', $lastpoll)));
		if ($id != '' || $id != 0) {
			$field_id                = 'getmailnewentry';
			$input_getmailnewentry = new html_checkbox(array(
				'name' => '_getmailnewentry',
				'id' => $field_id,
				'value' => '1'
			));
			$out .= sprintf("<tr><td class=\"title\"><label for=\"%s\">%s</label>:</td><td>%s</td></tr>\n", $field_id, rep_specialchars_output($this->gettext('getmailnewentry')), $input_getmailnewentry->show($newentry));
		}
		$out .= "\n</table>";
		$out .= '<br />' . "\n";
		$out .= "</fieldset>\n";
		$rcmail->output->add_gui_object('getmailform', 'getmail-form');
		return $out;
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function gen_table($attrib) {
		$rcmail = rcmail::get_instance();
		$userhere = $rcmail->user->data['username'];
		$out = '<fieldset><legend>'.$this->gettext('getmail_entries').' - '.$userhere.'</legend>'."\n";
		$out .= '<br />' . "\n";
		$get_table = new html_table(array(
			'id' => 'get-table',
			'class' => 'records-table',
			'cellspacing' => '0',
			'cols' => 4
		));
		$get_table->add_header(array(
			'width' => '184px'
		), $this->gettext('getmailserver'));
		$get_table->add_header(array(
			'width' => '184px'
		), $this->gettext('username'));
		$get_table->add_header(array(
			'width' => '26px'
		), '');
		$get_table->add_header(array(
			'width' => '26px'
		), '');
		$sql = "SELECT * FROM getmail WHERE userhere='$userhere'";
		$result = $rcmail->db->query($sql);
		$num_rows = $rcmail->db->num_rows($result);
		while ($row = $rcmail->db->fetch_assoc($result)) {
			$class = ($class == 'odd' ? 'even' : 'odd');
			if ($row['mailget_id'] == get_input_value('_id', RCUBE_INPUT_GET)) {
				$class = 'selected';
			}
			$get_table->set_row_attribs(array(
				'class' => $class,
				'id' => 'get_' . $row['mailget_id']
			));
			$this->_fetch_row($get_table, $row['server'], $row['user'], $row['active'], $row['mailget_id'], $attrib);
		}
		if ($num_rows == 0) {
			$get_table->add(array(
				'colspan' => '4'
			), rep_specialchars_output($this->gettext('noget')));
			$get_table->set_row_attribs(array(
				'class' => 'odd'
			));
			$get_table->add_row();
		}
		$out .= "<div id=\"get-cont\">" . $get_table->show() . "</div>\n";
		$out .= '<br />' . "\n";
		$out .= "</fieldset>\n";
		return $out;
	}
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	private function _fetch_row($get_table, $col_server, $col_user, $active, $id, $attrib) {
		$get_table->add(array('onclick' => 'getmail_edit('.$id.');'), $col_server);
		$get_table->add(array('onclick' => 'getmail_edit('.$id.');'), $col_user);
		$disable_button = html::img(array(
			'src' => $attrib['enableicon'],
			'alt' => $this->gettext('enabled'),
			'border' => 0,
			'id' => 'img_'.$id
		));
		$enable_button = html::img(array(
			'src' => $attrib['disableicon'],
			'alt' => $this->gettext('disabled'),
			'border' => 0,
			'id' => 'img_'.$id
		));
		$del_button = html::img(array(
			'src' => $attrib['deleteicon'],
			'alt' => $this->gettext('delete'),
			'border' => 0
		));
		if ($active == 1) { $status_button = $disable_button; }
		else { $status_button = $enable_button; }
		$get_table->add(array('id' => 'td_'.$id, 'onclick' => 'row_edit('.$id.','.$active.');'), $status_button);
		$get_table->add(array('id' => 'td_'.$id, 'onclick' => 'row_del('.$id.');'), $del_button);
		return $get_table;
	}
}
?>
