/* Getmail Roundcube Plugin (RC0.4 and above)
 * Version 1.0, March 17, 2013
 * Copyright (c) 2013, Ron Guerin <ron@vnetworx.net>
 * Forked from ispcp_fetchmail, developed by Arthur Mayer, a.mayer@citex.net
 * Released under GPL license (http://www.gnu.org/licenses/gpl.txt)
 */

if (window.rcmail) {
	rcmail.addEventListener('init', function(evt) {

	var tab = $('<span>').attr('id', 'settingstabplugingetmail_retriever').addClass('tablink'); 
	var button = $('<a>').attr('href', rcmail.env.comm_path+'&_action=plugin.getmail_retriever').html(rcmail.gettext('getmail','getmail_retriever')).appendTo(tab);
	button.bind('click', function(e){ return rcmail.command('plugin.getmail_retriever', this) });

	// add button and register commands
	rcmail.add_element(tab, 'tabs');
	rcmail.register_command('plugin.getmail_retriever', function() { rcmail.goto_url('plugin.getmail_retriever') }, true);

	rcmail.register_command('plugin.getmail_retriever.save', function() {
		var input_server = rcube_find_object('_getmailserver');
		var input_user = rcube_find_object('_getmailuser');
		var input_pass = rcube_find_object('_getmailpass');
		var input_poll = rcube_find_object('_getmailpoll');
		if(input_server.value == "" || input_user.value == "" || input_pass.value == "" || input_poll.value == ""){
			parent.rcmail.display_message(rcmail.gettext('textempty','getmail_retriever'), 'error');    
		} else {
			document.forms.getmailform.submit();
		}
	}, true);

	})
}

function getmail_edit(id){
	window.location.href = '?_task=settings&_action=plugin.getmail_retriever&_id='+id;
}

function row_del(id) {
	if(id == "") {
		parent.rcmail.display_message(rcmail.gettext('textempty','getmail_retriever'), 'error');
	}
	else {
		document.getElementById('get-table').deleteRow(document.getElementById('get_'+id).rowIndex);
		rcmail.http_request('plugin.getmail_retriever.del', '_id='+id, true);
		if(document.getElementById('get-table').getElementsByTagName("TBODY").item(0).rows.length == 0) {
			var tbody = document.getElementById('get-table').getElementsByTagName("TBODY").item(0);
			var row=document.createElement("TR");
			var cell = document.createElement("TD");
			var text=document.createTextNode(rcmail.gettext('noget','getmail_retriever'));
			cell.setAttribute('colspan', '4');
			cell.appendChild(text);
			row.appendChild(cell);
			tbody.appendChild(row);
		}
		parent.rcmail.display_message(rcmail.gettext('successfullydeleted','getmail_retriever'), 'confirmation');
	}
}

function row_edit(id, active) {
	if(id == "") {
		parent.rcmail.display_message(rcmail.gettext('textempty','getmail_retriever'), 'error');
	}
	else {
		if(active == 1) {
			var active = 0;
			document.getElementById('td_'+id).setAttribute('onclick', 'row_edit('+id+','+active+');');
			document.getElementById('img_'+id).src = 'plugins/getmail_retriever/skins/default/disabled.png';
			rcmail.http_request('plugin.getmail_retriever.disable', '_id='+id, true);
			parent.rcmail.display_message(rcmail.gettext('successfullydisabled','getmail_retriever'), 'confirmation');
		}
		else {
			var active = 1;
			document.getElementById('td_'+id).setAttribute('onclick', 'row_edit('+id+','+active+');');
			document.getElementById('img_'+id).src = 'plugins/getmail_retriever/skins/default/enabled.png';
			rcmail.http_request('plugin.getmail_retriever.enable', '_id='+id, true);
			parent.rcmail.display_message(rcmail.gettext('successfullyenabled','getmail_retriever'), 'confirmation');
		}
	}
}
