#!/usr/bin/env php
<?php

/* Getmail_Retriever Roundcube plugin backend script
 * Version 1.0, March 17, 2013
 * Copyright (c) 2013, Ron Guerin <ron@vnetworx.net>
 * This script reads the getmail table in the database and runs getmail as
 * needed.
 *
 * Configuration settings are in the config/config.inc.php file
 */

define('RCMAIL_VERSION', '1.0.0');
$path = dirname(realpath($argv[0]));
require_once($path.'/config/config.inc.php');
if (! array_key_exists('getmail_dir', $rcmail_config)) die("Must specify getmail_dir in config.inc.php\n");
$getdir = $rcmail_config['getmail_dir'];
if (! array_key_exists('getmail_rc_config', $rcmail_config)) die("Must specify getmail_rc_config in config.inc.php\n");
$config = $rcmail_config['getmail_rc_config'];
if (! array_key_exists('getmail_destination_type', $rcmail_config)) die("Must specify getmail_destination_type in config.inc.php\n");
$desttype = $rcmail_config['getmail_destination_type'];
if (! array_key_exists('getmail_destination_path', $rcmail_config)) die("Must specify getmail_destination_path in config.inc.php\n");
$destpath = $rcmail_config['getmail_destination_path'];
$destargs = (array_key_exists('getmail_destination_arguments', $rcmail_config) ? $rcmail_config['getmail_destination_arguments'] : NULL);
$mailbox = (array_key_exists('getmail_mailbox', $rcmail_config) ? $rcmail_config['getmail_mailbox'] : NULL);
$locktype = (array_key_exists('getmail_locktype', $rcmail_config) ? $rcmail_config['getmail_locktype'] : NULL);
$getmail = (array_key_exists('getmail', $rcmail_config) ? $rcmail_config['getmail'] : NULL);
$unixfrom = (array_key_exists('getmail_unixfrom', $rcmail_config) ? $rcmail_config['getmail_unixfrom'] : NULL);
$delivered = (array_key_exists('getmail_delivered_to', $rcmail_config) ? $rcmail_config['getmail_delivered_to'] : NULL);
$received = (array_key_exists('getmail_received', $rcmail_config) ? $rcmail_config['getmail_received'] : NULL);
$timeout = (array_key_exists('getmail_timeout', $rcmail_config) ? $rcmail_config['getmail_timeout'] : NULL);
$maxsize = (array_key_exists('getmail_max_message_size', $rcmail_config) ? $rcmail_config['getmail_max_message_size'] : NULL);
$maxsession = (array_key_exists('getmail_max_messages_per_session', $rcmail_config) ? $rcmail_config['getmail_max_messages_per_session'] : NULL);
$verbosity = (array_key_exists('getmail_verbose', $rcmail_config) ? $rcmail_config['getmail_verbose'] : NULL);
$syslog = (array_key_exists('getmail_message_log_syslog', $rcmail_config) ? $rcmail_config['getmail_message_log_syslog'] : NULL);
$logfile = (array_key_exists('getmail_message_log', $rcmail_config) ? $rcmail_config['getmail_message_log'] : NULL);
$logverbose = (array_key_exists('getmail_message_log_verbose', $rcmail_config) ? $rcmail_config['getmail_message_log_verbose'] : NULL);
$trace = (array_key_exists('getmail_trace', $rcmail_config) ? $rcmail_config['getmail_trace'] : NULL); if ($trace) $trace = ' --trace';
require_once($config.'/main.inc.php');
require_once($config.'/db.inc.php');

if ($syslog) {
	openlog('getmail-retriever', LOG_PID, LOG_MAIL);
	syslog(LOG_INFO, 'Processing.');
}

chdir($getdir);

// Connect to the database
try {
	switch ($dbtype) {
		case 'mysql': case 'pgsql':
			$dbh = new PDO("$dbtype:host=$dbserver;dbname=$dbname", $dbuser, $dbpass);
			break;
		case 'sqlite':
			$dbh = new PDO("sqlite:$dbname");
			break;
		}
}
catch(PDOException $e) {
	echo $e->getMessage();
}

$now = date('U'); // Grab the time to use for rest of this run
$sth = $dbh->query('SELECT `mailget_id`, `userhere`, `type`, `ssl`, `delete`, `getallnext`, `getonlynew`, `server`, `user`, `pass`, `folder`, `lastpoll`, `poll` FROM getmail WHERE active=\'1\' AND (lastpoll+(poll*60) <= '.$now.')');

// Set the fetch mode
$sth->setFetchMode(PDO::FETCH_ASSOC);

// Loop through, build .getmailrc files in /var/mail/getmail, call getmail, update lastpoll
$getmailrc = array();
while($row = $sth->fetch()) {
	#echo $row['userhere']."\n";
    $userdir = $getdir."/".$row['userhere']."-".$row['mailget_id'];
    if ((! file_exists($userdir)) && (! mkdir($userdir))) {
		if ($syslog) syslog(LOG_INFO, "Could not use or create userdir: $userdir, skipping.");
		continue;
	}
    $getmailrc[] = "[options]\n";
    if ($verbosity != NULL) $getmailrc[] = "verbose = $verbosity\n";
	if ($syslog != NULL) $getmailrc[] = "message_log_syslog = true\n";
	if (($logfile != NULL) && ($logfile !== FALSE)) $getmailrc[] = "message_log = $userdir/".$row['userhere'].".log\n";
	if ($logverbose != NULL) $getmailrc[] = "message_log_verbose = $logverbose\n";
	if ($row['getallnext'] == 1) $getmailrc[] = "read_all = true\n"; // one-time setting or normal setting
	else $getmailrc[] = "read_all = ".($row['getonlynew'] ? 'false' : 'true')."\n";
	if ($row['delete'] == 1) $getmailrc[] = "delete = true\n"; // delete must be unset or true
	if ($timeout != NULL) $getmailrc[] = "timeout = $timeout\n";
	if ($maxsize != NULL) $getmailrc[] = "max_message_size = $maxsize\n";
	if ($maxsession != NULL) $getmailrc[] = "max_messages_per_session = $maxsession\n";
	if ($received != NULL) $getmailrc[] = "received = $received\n";
	if ($delivered != NULL) $getmailrc[] = "delivered_to = $delivered\n";
	$getmailrc[] = "\n";
	$getmailrc[] = "[retriever]\n";
	$ssl = ($row['ssl'] ? 'SSL' : '');
	switch ($row['type']) {
		case 'imap':
			$getmailrc[] = "type = SimpleIMAP".$ssl."Retriever\n";
			if (trim($row['folder']) != '') $getmailrc[] = "mailboxes = (\"".$row['folder']."\")\n";
			break;
		case 'pop3':
			$getmailrc[] = "type = SimplePOP3".$ssl."Retriever\n";
			break;
	}
	$getmailrc[] = "server = ".$row['server']."\n";
	$getmailrc[] = "username = ".$row['user']."\n";
	$getmailrc[] = "password = ".$row['pass']."\n";
	$getmailrc[] = "\n";
	$getmailrc[] = "[destination]\n";
	$getmailrc[] = "type = $desttype\n";
	$thisdest = apply_vars($destpath, $row['userhere']);
	$getmailrc[] = "path = $thisdest\n";
	if ($destargs) {
		$firstarg = TRUE; $args = '';
		$preargs = "arguments = (";
		foreach ($destargs as $arg) {
			$arg = apply_vars($arg, $row['userhere']);
			if ($firstarg) $firstarg = FALSE; else $args .= ',';
			$args .= '"'.$arg.'"';
		}
		$getmailrc[] = $preargs.$args.")\n";
	}
	if ($locktype) $getmailrc[] = "locktype = $locktype\n";
	if ($unixfrom) $getmailrc[] = "unixfrom = true\n";
	$file = $userdir.'/'.$row['userhere'].".getmailrc";
	$ret = file_put_contents($file, $getmailrc); // Write out the getmailrc file
	if ($ret !== FALSE) {
		exec($getmail." --getmaildir='".$userdir."' --rcfile='".$file."'".$trace, $output, $exitcode);
		if ($exitcode == 0) {
			$data = array($now);
			$req = "UPDATE getmail SET lastpoll=?";
			if ($row['getallnext']) {
				$data[] = FALSE; // reset getallnext to FALSE
				$req .= ", getallnext=?";
			}
			$data[] = $row['mailget_id'];
			$req .= " WHERE mailget_id=?";
			$sth = $dbh->prepare($req);
			$sth->execute($data);
		}
		else {
			if ($syslog) syslog(LOG_INFO, "Error $exitcode running getmail for $file.");
		}
	}
	else {
		if ($syslog) syslog(LOG_INFO, "Could not create $file, skipping.");
	}
}

function apply_vars($string, $value) {
	$string = str_replace('%(local)', strstr($value, '@', TRUE), $string);
	$string = str_replace('%(domain)', substr(strstr($value, '@'), 1), $string);
	$string = str_replace('%(recipient)', $value, $string);
	return $string;
}
?>
